/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.history;

import com.aptana.git.core.model.GitCommit;
import com.aptana.git.core.model.GitRef;
import com.aptana.git.ui.internal.history.GitGraphLine;
import com.aptana.git.ui.internal.history.GitGrapher;
import com.aptana.git.ui.internal.history.GraphCellInfo;
import com.aptana.git.ui.internal.history.Messages;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CommitGraphTable
extends TableViewer {
    private BranchPainter renderer;
    private Map<GitCommit, GraphCellInfo> decorations;
    private List<GitCommit> commits;

    CommitGraphTable(Composite parent) {
        super(parent, 268503810);
        this.renderer = new BranchPainter(parent.getDisplay());
        final Table table = this.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        TableColumn graph = new TableColumn(table, 0);
        graph.setResizable(true);
        graph.setText("");
        graph.setWidth(250);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        TableColumn author = new TableColumn(table, 0);
        author.setResizable(true);
        author.setText(Messages.CommitGraphTable_AuthorColumn_Label);
        author.setWidth(250);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, true));
        TableColumn date = new TableColumn(table, 0);
        date.setResizable(true);
        date.setText(Messages.CommitGraphTable_DateColumn_Label);
        date.setWidth(250);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(5, true));
        this.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.setLabelProvider((IBaseLabelProvider)new CommitLabelProvider());
        this.createPaintListener(table);
        table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CommitGraphTable.this.renderer.dispose();
            }
        });
        table.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                if (CommitGraphTable.this.commits == null) {
                    return;
                }
                TableItem item = (TableItem)event.item;
                int index = table.indexOf(item);
                item.setData(CommitGraphTable.this.commits.get(index));
            }
        });
    }

    void setCommits(List<GitCommit> commits) {
        this.commits = commits;
        this.decorations = new GitGrapher().decorateCommits(commits);
        this.setInput(commits);
        if (!commits.isEmpty()) {
            this.setSelection((ISelection)new StructuredSelection((Object)commits.get(0)));
        }
    }

    private void createPaintListener(Table rawTable) {
        rawTable.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                if (event.index >= 0 && event.index <= 2) {
                    event.detail &= 0xFFFFFFEF;
                }
            }
        });
        rawTable.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                CommitGraphTable.this.doPaint(event);
            }
        });
    }

    private void doPaint(Event event) {
        if (event.index == 0) {
            this.renderer.paint(event);
            return;
        }
        GitCommit c = (GitCommit)((TableItem)event.item).getData();
        ITableLabelProvider lbl = (ITableLabelProvider)this.getLabelProvider();
        String txt = lbl.getColumnText((Object)c, event.index);
        Point textsz = event.gc.textExtent(txt);
        int texty = (event.height - textsz.y) / 2;
        event.gc.drawString(txt, event.x, event.y + texty, true);
    }

    private class BranchPainter {
        private static final int HORIZONTAL_PADDING = 8;
        private static final int LANE_WIDTH = 10;
        private static final int LINE_WIDTH = 2;
        private GC g;
        private int cellX;
        private int cellY;
        private Color cellFG;
        private Color cellBG;
        private Color blue;
        private Color yellow;
        private Color green;
        private Color red;
        private Color purple;
        private Color orange;
        private Color[] laneColors;
        private Color sys_black;
        private Color sys_white;
        private Color refOrange;
        private Color refBlue;
        private Color refYellow;
        private Color[] refColors;

        BranchPainter(Display d) {
            this.blue = new Color((Device)d, 41, 94, 153);
            this.yellow = new Color((Device)d, 207, 173, 0);
            this.green = new Color((Device)d, 93, 166, 1);
            this.red = new Color((Device)d, 181, 23, 0);
            this.purple = new Color((Device)d, 112, 72, 121);
            this.orange = new Color((Device)d, 216, 112, 0);
            this.laneColors = new Color[]{this.green, this.blue, this.yellow, this.purple, this.red, this.orange};
            this.refOrange = new Color((Device)d, 253, 180, 97);
            this.refBlue = new Color((Device)d, 190, 229, 254);
            this.refYellow = new Color((Device)d, 252, 237, 96);
            this.refColors = new Color[]{this.refOrange, this.refBlue, this.refYellow};
            this.sys_black = d.getSystemColor(2);
            this.sys_white = d.getSystemColor(1);
        }

        void dispose() {
            Color color;
            Color[] colorArray = this.laneColors;
            int n = this.laneColors.length;
            int n2 = 0;
            while (n2 < n) {
                color = colorArray[n2];
                color.dispose();
                ++n2;
            }
            colorArray = this.refColors;
            n = this.refColors.length;
            n2 = 0;
            while (n2 < n) {
                color = colorArray[n2];
                color.dispose();
                ++n2;
            }
        }

        public void paint(Event event) {
            this.g = event.gc;
            this.cellX = event.x;
            this.cellY = event.y;
            this.cellFG = this.g.getForeground();
            this.cellBG = this.g.getBackground();
            TableItem ti = (TableItem)event.item;
            this.paintCommit((GitCommit)ti.getData(), event.height);
        }

        private void paintCommit(GitCommit commit, int height) {
            int myLaneX;
            if (commit == null) {
                return;
            }
            GraphCellInfo info = CommitGraphTable.this.decorations == null ? null : (GraphCellInfo)CommitGraphTable.this.decorations.get(commit);
            int maxCenter = myLaneX = 15;
            if (info != null) {
                for (GitGraphLine line : info.getLines()) {
                    int y1 = 0;
                    int y2 = height / 2;
                    if (!line.isUpper()) {
                        y1 = height / 2;
                        y2 = height;
                    }
                    int x1 = line.getFrom() * 10 + 5;
                    int x2 = line.getTo() * 10 + 5;
                    maxCenter = Math.max(maxCenter, Math.max(x1, x2));
                    if (line.getTo() == info.getPosition()) {
                        myLaneX = x1 == x2 ? x1 + 1 : Math.min(x1, x2) + 1;
                    }
                    this.drawLine(this.color(line.getIndex()), x1, y1, x2, y2, 2);
                }
            }
            int dotSize = this.computeDotSize(height);
            int dotX = myLaneX - dotSize / 2 - 1;
            int dotY = (height - dotSize) / 2;
            this.drawCommitDot(dotX, dotY, dotSize, dotSize);
            String msg = commit.getSubject();
            int textx = Math.max(maxCenter + 5, dotX + dotSize) + 8;
            int n = commit.refCount();
            if (commit.hasRefs()) {
                for (GitRef ref : commit.getRefs()) {
                    textx += this.drawLabel(textx + dotSize, height / 2, ref);
                }
            }
            this.drawText(msg, textx + dotSize + n * 2, height / 2);
        }

        protected int drawLabel(int x, int y, GitRef ref) {
            ++y;
            String txt = ref.shortName();
            if (ref.type().equals((Object)GitRef.TYPE.HEAD)) {
                this.g.setBackground(this.refOrange);
            } else if (ref.type().equals((Object)GitRef.TYPE.REMOTE)) {
                this.g.setBackground(this.refBlue);
            } else if (ref.type().equals((Object)GitRef.TYPE.TAG)) {
                this.g.setBackground(this.refYellow);
            } else {
                this.g.setBackground(this.sys_white);
            }
            if (txt.length() > 12) {
                txt = String.valueOf(txt.substring(0, 11)) + "\u2026";
            }
            Point textsz = this.g.stringExtent(txt);
            int arc = textsz.y / 2;
            int texty = (y * 2 - textsz.y) / 2;
            this.g.fillRoundRectangle(x + 1, this.cellY + texty, textsz.x + 3, textsz.y - 1, arc, arc);
            this.g.setForeground(this.sys_black);
            this.g.drawString(txt, x + 2, this.cellY + texty, true);
            this.g.setLineWidth(2);
            this.g.setLineWidth(1);
            this.g.setForeground(this.sys_black);
            this.g.drawRoundRectangle(x + 1, this.cellY + texty, textsz.x + 3, textsz.y - 1, arc, arc);
            this.g.setAlpha(255);
            return 8 + textsz.x;
        }

        protected void drawCommitDot(int x, int y, int w, int h) {
            this.g.fillOval(this.cellX + x, this.cellY + y, w, h);
            this.g.setForeground(this.cellFG);
            this.g.setLineWidth(2);
            this.g.drawOval(this.cellX + x, this.cellY + y, w, h);
        }

        private int computeDotSize(int h) {
            int d = (int)((float)Math.min(h, 10) * 0.5f);
            d += d & 1;
            return d;
        }

        private Color color(int index) {
            return this.laneColors[index % this.laneColors.length];
        }

        protected void drawLine(Color color, int x1, int y1, int x2, int y2, int width) {
            this.g.setForeground(color);
            this.g.setLineWidth(width);
            this.g.drawLine(this.cellX + x1, this.cellY + y1, this.cellX + x2, this.cellY + y2);
        }

        protected void drawText(String msg, int x, int y) {
            Point textsz = this.g.textExtent(msg);
            int texty = (y * 2 - textsz.y) / 2;
            this.g.setForeground(this.cellFG);
            this.g.setBackground(this.cellBG);
            this.g.drawString(msg, this.cellX + x, this.cellY + texty, true);
        }
    }

    private static class CommitLabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        private static final SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        private CommitLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            GitCommit commit = (GitCommit)element;
            if (commit == null) {
                return "";
            }
            switch (columnIndex) {
                case 0: {
                    return commit.getSubject();
                }
                case 1: {
                    return commit.getAuthor();
                }
                case 2: {
                    return fmt.format(commit.date());
                }
            }
            return "";
        }
    }
}

